
---

## **1. Overview of Cisco Identity Based Networking Services  (IBNS 2.0)**

### **Why Cisco IBNS 2.0?**

- Traditional 802.1X configurations required numerous commands per interface, leading to configuration bloat and maintenance challenges in large-scale environments.
- Modern networks need a flexible, scalable, and policy-driven framework to:
    - Enable differentiated authentication methods.
    - Provide flexible authorization mechanisms.
    - Address compatibility issues (e.g., low-impact mode and inaccessible authentication bypass incompatibility).

### **Key Features**

- A **policy- and identity-based framework** for secure network access.
- Supports **any authentication** with **any authorization** across wired and wireless media.
- Uses **Cisco Common Classification Policy Language (C3PL)** for consistent and scalable policy definitions.
- Simplifies configuration through **service templates** and **interface templates**.

---

## **2. Key Components of Cisco IBNS 2.0**

### **Advanced Access Session Manager**

- Core component providing a flexible authentication framework.
- Uses **identity control policies** to define actions based on conditions and events.

### **Control Policies**

- Define system behavior based on:
    - **Event**: Triggers (e.g., session start, authentication failure).
    - **Condition**: Match criteria (e.g., endpoint characteristics).
    - **Action**: System function (e.g., authenticate, authorize, apply VLAN).

#### **Steps to Define a Control Policy**

1. **Create Control Classes**:
    - Define conditions for policy activation (e.g., match result-type or authorization status).
2. **Create Control Policy Rules**:
    - Combine control classes with events and actions.
3. **Apply Control Policy**:
    - Activate policies on interfaces or through templates.

---

## **3. Cisco IBNS 2.0 Templates**

### **Types of Templates**

1. **Service Templates**:
    
    - Dynamically assigned based on events (e.g., AAA server timeout).
    - Can assign VLANs, ACLs, and other attributes.
    - Can be defined locally on a switch or dynamically pushed from an AAA server (e.g., Cisco ISE).
    
    **Example**:
    
    ```bash
    service-template CRITICAL_AUTH_VLAN
    vlan 88
    access-group PERMIT_ANY
    ```
    
2. **Interface Templates**:
    
    - Group common interface settings (e.g., VLAN, spanning-tree, 802.1X settings).
    - Prevent configuration bloat by centralizing interface-specific commands.
    
    **Example**:
    
    
    ```bash
    template ACCESS_PORTS
    switchport mode access
    switchport access vlan 10
    dot1x pae authenticator
    authentication periodic
    ```
    

---

## **4. Benefits of Cisco IBNS 2.0**

- **Simplified Configuration**: Reduces per-interface commands using templates.
- **Scalability**: Provides consistent policies across large environments.
- **Flexibility**: Supports various authentication and authorization methods.
- **Compatibility**: Resolves legacy issues (e.g., low-impact mode and inaccessible authentication bypass).

---

## **5. Migrating from Cisco IBNS 1.0 to 2.0**

- **Automatic Migration**:
    - Use the `authentication display new-style` command to convert legacy configurations.
    - Example: Cisco IBNS 1.0 interface configurations (detailed and lengthy) are migrated to Cisco IBNS 2.0 with simplified templates and policies.
- **Manual Adjustments**:
    - Add **interface templates** to consolidate per-interface settings.
    - Use **service templates** for event-based actions.

**Note**: Once configuration is saved in IBNS 2.0, reverting to IBNS 1.0 is not possible without a reload.

---

## **6. Example: Low-Impact Mode with Cisco IBNS 2.0**

### **Use Case**

Deploy 802.1X in low-impact mode with pre-authentication ACLs and support for inaccessible authentication bypass.

### **Configuration Steps**

1. **Define Access Lists**:
    
    - **Critical ACL (e.g., when RADIUS is unreachable)**:
        
        ```bash
        ip access-list extended CRITICAL_AUTH_ACL
        permit ip any any
        ```
        
    - **Pre-authentication ACL**:
        
        
        ```bash
        ip access-list extended PRE_AUTH_ACL
        permit udp any eq bootpc any eq bootps
        permit udp any any eq domain
        deny ip any any
        ```
        
2. **Create Service Templates**:
    
    - Assign VLANs and ACLs dynamically when RADIUS servers are down:
        
        
        ```bash
        service-template CRITICAL_AUTH_SRV_TEMPLATE
        access-group CRITICAL_AUTH_ACL
        vlan 10
        voice vlan
        ```
        
3. **Define Class Maps**:
    
    - Match authentication events (e.g., timeouts, failures):
        
        
        ```bash
        class-map type control subscriber match-all DOT1X_FAILED
        match method dot1x
        match result-type method dot1x authoritative
        ```
        
4. **Create Control Policies**:
    
    - Define actions for events (e.g., apply service templates on RADIUS failure):
        
        
        ```bash
        policy-map type control subscriber 802_1X_LowImpactMode_Policy
        event authentication-failure match-first
          class DOT1X_FAILED
            authenticate using mab priority 20
          class AAA_SVR_DOWN_UNAUTHD_HOST
            activate service-template CRITICAL_AUTH_SRV_TEMPLATE
            authorize
        ```
        
5. **Create Interface Template**:
    
    - Group all relevant 802.1X and authentication settings:
        
        
        ```bash
        template 802_1X_LowImpactMode_Template
        device-tracking
        ip access-group PRE_AUTH_ACL in
        dot1x pae authenticator
        mab
        service-policy type control subscriber 802_1X_LowImpactMode_Policy
        ```
        
6. **Apply Template to Interfaces**:
    
    
    ```bash
    interface GigabitEthernet1/0/1
    switchport mode access
    switchport access vlan 10
    source template 802_1X_LowImpactMode_Template
    ```
    

### **Verification Commands**

- Verify applied templates:
    
    
    ```bash
    show running-config interface GigabitEthernet1/0/1
    ```
    
- Check derived configuration:
        
    ```bash
    show derived-config interface GigabitEthernet1/0/1
    ```
    

---

## **7. Key Notes**

- Cisco IBNS 2.0 provides a more manageable, flexible, and scalable solution for 802.1X deployments compared to IBNS 1.0.
- Migration tools simplify transitioning from legacy configurations while retaining compatibility.
- Templates and policies reduce configuration complexity, especially in large-scale deployments.